import javax.swing.*;
import java.awt.*;
  
/** An instance is  picture of a clock. */
public class Clock extends Canvas {
   private Time time;              // time displayed on the clock

   private final int width= 250;   // size of Canvas
   private final int height= 250;  // width of Canvas
   private final int radius= (Math.min(width,height)-30)/2; // radius of clock
   private final int xMid= 15+radius;    // (xmid, ymix) the center of clock
   private final int yMid= 15+radius;
   
   /** Constructor: a clock with time (0,0) */
   public Clock () {
      this(new Time(0,0));
   }
   
   /** Constructor: a clock with time t */
   public Clock(Time t) {
      time= t;
      setBackground(new Color(255, 235, 222));
      setSize(width, height);
  }
   
   /** = the time */
   public Time getTime() {
      return time;
   }
   
   /** Set the time to t */
   public void setTime(Time t) {
      time= t;
      repaint();
   }
   
   // Paint the clock
   public void paint(Graphics g) {
      drawFace(g);
      // Draw the minute hand
         int min= time.getMinutes();
         drawHand(radius*0.7, min*2*Math.PI/60.0, 1, g);
      // Draw the hour hand
         int hr= time.getHours();
         drawHand(radius*0.55, (hr + min/60.0)*2*Math.PI/12.0, 3, g);
   }   
   
   /** Draw the clock face with Graphics g */
   private void drawFace(Graphics g) {
      Color save= g.getColor();
      g.setColor(Color.red);
      g.drawOval(xMid-radius, yMid-radius, 2*radius, 2*radius);
      g.setColor(Color.black);       
      // Draw the ticks
         for (int i= 0; i != 60; i= i+1) {
             if (i % 5 == 0)
                drawTick(20,i*2*Math.PI/60.0, g);
             else
                drawTick(7, i*2*Math.PI/60.0, g);
         }
      g.setColor(save);
   }
   
   // Draw a tick of length len at angle l
   private void drawTick(double len, double ang, Graphics g) {
      // Determine beginning point (x2,y2)
         int x0= (int)(xMid + Math.round((radius-len)*Math.sin(ang)));
         int y0= (int)(yMid - Math.round((radius-len)*Math.cos(ang)));
      // Determine end point (x1,y1)
         int x1= (int)(xMid + Math.round(radius*Math.sin(ang)));
         int y1= (int)(yMid - Math.round(radius*Math.cos(ang)));
      g.drawLine(x0, y0, x1, y1);
   }
   
   /** Draw hand with length len and angle ang, using g.
       Parameter fatness is the number of lines to draw 
       (in range 1..3) in order to get fat or thin hands */
   private void drawHand(double len, double ang, int fatness, Graphics g) {
      Color save= g.getColor();
      g.setColor(Color.black);
      int x1= (int)(xMid + Math.round(len*Math.sin(ang)));
      int y1= (int)(yMid - Math.round(len*Math.cos(ang)));
      g.drawLine(xMid, yMid, x1, y1);
      if (fatness == 1) return;
      g.drawLine(xMid+1, yMid, x1+1, y1);
      g.drawLine(xMid, yMid+1, x1, y1+1);
      if (fatness == 2) return;
      g.drawLine(xMid-1, yMid, x1-1, y1);
      g.drawLine(xMid, yMid-1, x1, y1-1);
      g.setColor(save);
   }
}
